/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.Edid;
import com.quantumdata.edideditor.EdidEditor;
import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpFile;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import com.quantumdata.std.StdConnectionManager;
import com.quantumdata.std.SystemConsole;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class GeneratorCommunicator {
    private SocketConnection con = null;
    private RemoteInstrument instr = null;
    private InstrumentResponse resp = null;
    private String ipAddress = null;
    private FtpConnect ftpCon = null;
    private Ftp ftpClient = null;

    public GeneratorCommunicator(EdidEditor edidEditor) {
        StdConnectionManager stdConnectionManager = new StdConnectionManager(edidEditor);
        this.instr = stdConnectionManager.newConnection();
        this.con = (SocketConnection)this.instr.getConnection();
        this.set882Address(this.con.getName());
    }

    public String set882Address(String string) {
        this.ipAddress = string;
        return this.testCommunication();
    }

    public String get882Address() {
        return this.ipAddress;
    }

    public void disconnect() {
        if (this.instr != null) {
            this.instr.disconnect();
        }
        if (this.ftpCon != null) {
            this.DisconnectFromFTP();
        }
    }

    public boolean isSupportedInstrument() {
        String string = this.checkConnection();
        if (string != null && string.indexOf("ERROR") != -1) {
            return false;
        }
        InstrumentResponse instrumentResponse = this.instr.sendCmd("*IDN?");
        if (instrumentResponse.isError()) {
            return false;
        }
        String[] stringArray = instrumentResponse.getResponse().split(",");
        if (stringArray.length < 2) {
            return false;
        }
        return stringArray[1].indexOf("881") != 0;
    }

    public String getFileListing() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.checkConnection();
        if (string != null && string.indexOf("ERROR") != -1) {
            return string;
        }
        this.resp = this.instr.sendCmd("didp /tffs0/Library/EDID");
        if (this.resp.isError()) {
            stringBuffer.append("Error retrieving files");
            return stringBuffer.toString();
        }
        boolean bl = true;
        int n = 1;
        int n2 = 10;
        while (bl) {
            this.resp = this.instr.sendCmd("didq? " + n + " " + n2);
            if (this.resp.isError()) {
                stringBuffer.append("Error retrieving files");
                return stringBuffer.toString();
            }
            string = this.resp.getResponse();
            if (string.length() < 1) {
                bl = false;
            } else {
                bl = true;
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
            n += n2;
        }
        return stringBuffer.toString();
    }

    public String getNumberOfEmulatorPorts() {
        String string = this.checkConnection();
        if (string != null && string.indexOf("ERROR") != -1) {
            return string;
        }
        this.resp = this.instr.sendCmd("edex:nede?");
        return this.resp.getResponse();
    }

    public String getNumberOfAnalyzerPorts() {
        String string = this.checkConnection();
        if (string != null && string.indexOf("ERROR") != -1) {
            return string;
        }
        this.resp = this.instr.sendCmd("edax:neda?");
        return this.resp.getResponse();
    }

    public String saveEDIDTo882(String string, String string2) {
        String string3 = this.checkConnection();
        if (string3 != null && string3.indexOf("ERROR") != -1) {
            return string3;
        }
        if (string.length() < 256) {
            return "ERROR: EDID is less than one block";
        }
        this.writeEDIDTo882(string);
        if (string2 != "") {
            this.resp = this.instr.sendCmd("dida " + string2);
            if (this.resp.isError()) {
                return this.resp.getResponse();
            }
        }
        return null;
    }

    public String saveEDIDToDUT(int n, String string) {
        String string2 = this.checkConnection();
        if (string2 != null && string2.indexOf("ERROR") != -1) {
            return string2;
        }
        if (string.length() < 256) {
            return "ERROR: EDID is less than one block";
        }
        this.writeEDIDTo882(string);
        this.resp = this.instr.sendCmd("eda" + n + ":pdid");
        if (this.resp.isError()) {
            return this.resp.getResponse();
        }
        return null;
    }

    public String useEDIDOn882(String string, int n) {
        String string2 = this.checkConnection();
        if (string2 != null && string2.indexOf("ERROR") != -1) {
            return string2;
        }
        this.writeEDIDTo882(string);
        this.resp = this.instr.sendCmd("ede" + n + ":didu");
        if (this.resp.isError()) {
            string2 = this.resp.getResponse();
        }
        return string2;
    }

    public String generateViewEDIDReports(String string) {
        String string2 = null;
        string2 = this.writeEDIDTo882(string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.generateEDIDReport();
        return string2;
    }

    public String generateEDIDReport() {
        String string = null;
        String string2 = this.checkConnection();
        if (string2 != null && string2.indexOf("ERROR") != -1) {
            return string2;
        }
        this.resp = this.instr.sendCmd("ectx:ectu");
        if (this.resp.isError()) {
            string = this.resp.getResponse();
            return string;
        }
        return string;
    }

    public String loadXMLFileFrom882(String string, Edid edid) {
        BufferedReader bufferedReader = null;
        String string2 = null;
        if (this.ftpCon == null) {
            string2 = this.ConnectToFTP();
        }
        if (string2 != null) {
            return string2;
        }
        try {
            if (!this.ftpClient.connect(this.ftpCon)) {
                string2 = "FTP Connection failed.";
                return string2;
            }
            if (this.ftpClient.pwd() != "/tffs0/Library/EDID") {
                this.ftpClient.cd("/tffs0/Library/EDID");
            }
            FtpFile ftpFile = new FtpFile(string, this.ftpClient);
            InputStream inputStream = ftpFile.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        catch (IOException iOException) {
            string2 = "--> Error: " + iOException.getMessage();
            this.DisconnectFromFTP();
            return string2;
        }
        string2 = edid.parseEDID(bufferedReader);
        this.DisconnectFromFTP();
        return string2;
    }

    public String loadEDIDFromDUT(int n, Edid edid) {
        String string = null;
        String string2 = this.checkConnection();
        if (string2 != null && string2.indexOf("ERROR") != -1) {
            return string2;
        }
        this.resp = this.instr.sendCmd("eda" + n + ":gdid");
        if (this.resp.isError()) {
            string = this.resp.getResponse();
            return string;
        }
        String string3 = "edidPort" + n + ".xml";
        this.resp = this.instr.sendCmd("didp? /tffs0/Library/EDID");
        if (this.resp.isError()) {
            string = this.resp.getResponse();
            return string;
        }
        this.resp = this.instr.sendCmd("dida " + string3);
        if (this.resp.isError()) {
            string = this.resp.getResponse();
            return string;
        }
        string = this.loadXMLFileFrom882(string3, edid);
        return string;
    }

    private String testCommunication() {
        String string = null;
        string = this.ConnectToCmdLine();
        if (string != null && string.indexOf("ERROR") != -1) {
            string = "Please check the network connection to the 882 at " + this.ipAddress;
        }
        return string;
    }

    private String ConnectToCmdLine() {
        String string = null;
        if (this.ipAddress == null) {
            string = "ERROR! Please specify an IP Address for the 882";
            return string;
        }
        this.con = new SocketConnection(this.ipAddress);
        this.instr = new RemoteInstrument(this.con, new SystemConsole());
        try {
            this.instr.connect();
        }
        catch (InstrumentException instrumentException) {
            string = "Failed to connect to the command line interface";
        }
        return string;
    }

    private String ConnectToFTP() {
        String string = null;
        this.ftpCon = new FtpConnect();
        this.ftpClient = new Ftp();
        if (this.instr == null) {
            string = this.ConnectToCmdLine();
        }
        if (string != null && string.indexOf("ERROR") != -1) {
            return string;
        }
        SocketConnection socketConnection = (SocketConnection)this.instr.getConnection();
        this.ftpCon.setHostName(socketConnection.getHostName());
        this.ftpCon.setPassWord("");
        this.ftpCon.setUserName("");
        return string;
    }

    private void DisconnectFromFTP() {
        this.ftpClient.disconnect();
        this.ftpCon = null;
    }

    private String writeEDIDTo882(String string) {
        String string2 = new String();
        String string3 = this.checkConnection();
        int n = 0;
        if (string3 != null && string3.indexOf("ERROR") != -1) {
            return string3;
        }
        for (int i = 0; i < string.length(); i += 256) {
            string2 = string2.concat("xdid ");
            string2 = string2.concat(String.format("%02X", i / 2));
            string2 = string2.concat(" 80 ");
            n = i + 256;
            string2 = string2.concat(string.substring(i, n));
            if (this.instr == null) {
                return "Error! Please specify an IP address for the 882";
            }
            this.resp = this.instr.sendCmd(string2);
            if (this.resp.isError()) {
                string3 = this.resp.getResponse();
                return string3;
            }
            string2 = null;
            string2 = new String();
        }
        return string3;
    }

    public String getReportFileFrom882(File file, boolean bl) {
        BufferedReader bufferedReader = null;
        FtpFile ftpFile = null;
        InputStream inputStream = null;
        String string = null;
        if (this.ftpCon == null) {
            string = this.ConnectToFTP();
        }
        if (string != null) {
            return string;
        }
        try {
            if (!this.ftpClient.connect(this.ftpCon)) {
                string = "FTP Connection Failed.";
            }
            this.ftpClient.cd(this.GetReportPathFrom882());
            ftpFile = bl ? new FtpFile("Edid_Compliance.htm", this.ftpClient) : new FtpFile("Edid_Data.htm", this.ftpClient);
            inputStream = ftpFile.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string2;
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    bufferedWriter.write(string2);
                }
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                return "Failed to read the EDID report file";
            }
            inputStream.close();
            this.DisconnectFromFTP();
        }
        catch (IOException iOException) {
            string = "--> Error: " + iOException.getMessage();
        }
        return string;
    }

    public String GetReportPathFrom882() {
        String string = this.checkConnection();
        if (string != null && string.indexOf("ERROR") != -1) {
            return string;
        }
        return this.instr.sendCmd("RPTP?").getResponse();
    }

    private String checkConnection() {
        if (this.instr == null) {
            return "Error! Please specify an IP address for the 882";
        }
        String string = null;
        if (this.con == null) {
            string = this.ConnectToCmdLine();
        }
        return string;
    }
}

